/*--------------------------------------------------------
----------------------------------------------------------
REPLICATION PACKAGE

Does Immigration Affect Native Wages? A Meta-Analysis
Nedoncelle, Marchal, Aubry, Hericourt
Labour Economics

Last code update: 23/09/2025  
By: Lea Marchal 
Contact: lea.marchal@univ-paris1.fr

Operating system: LINUX
Stat version: Stata MP 19 for Unix
----------------------------------------------------------
--------------------------------------------------------*/
 
clear all
discard
set more off
cap log close
set seed 12345

pwd
cd "/mypath/replication/" // UPDATE THE PATH WITH YOUR FOLDER
shell rm -r "./output" 
mkdir "./output"
shell rm -r "./temp" 
mkdir "./temp"
cap program drop loaddata 
program loaddata
	use "./dataset.dta", clear
end
global pathout "./output/"
global pathdo "./dofiles/"
global pathtemp "./temp/"
mkdir "./output/section_3" 
mkdir "./output/section_4" 
mkdir "./output/section_5" 
	
	
* Prepare datasets and generate variables 
	do ${pathdo}prepare_datasets.do 
	
	* Dataset with all estimates
	cap program drop usedata_all
	program usedata_all
		use ${pathtemp}data_all.dta, clear
	end
	
	* Dataset with elasticities only
	cap program drop usedata_ela
	program usedata_ela
		use ${pathtemp}data_ela.dta, clear
	end
	
	* Dataset with semi-elasticities only
	cap program drop usedata_semi
	program usedata_semi
		use ${pathtemp}data_semi.dta, clear
	end
	
	* Dataset with both (converted) elasticities and (converted) semi-elasticities
	cap program drop usedata_ela_semi
	program usedata_ela_semi
		use ${pathtemp}data_ela_semi.dta, clear
	end
	
	* Dataset with estimates in absolute value
	cap program drop usedata_all_abs
	program usedata_all_abs
		usedata_all
		gen coeff = abs(e_beta)
		meta set coeff e_se, studylabel(p_id) studysize(nr_e) eslabel(Effect size (abs)) 
	end
	
	* Dataset a dummy (1: positive estimate, 0: negative estimate)
	cap program drop usedata_all_d
	program usedata_all_d
		usedata_all
		gen coeff = .
		replace coeff = 0 if e_beta<0
		replace coeff = 1 if e_beta>0
		keep if coeff!=.
		meta set coeff e_se, studylabel(p_id) studysize(nr_e) eslabel(Effect size (dummy)) 
	end
	
	
* Generate results for Section 3. Data and Empirical Strategy
		global output "${pathout}section_3/" 
		do ${pathdo}section_3.do 


* Generate results for Section 4. Results
		pwd
		global output "${pathout}section_4/" 
		do ${pathdo}section_4.do 


* Generate results for Section 5. Extensions
		pwd
		global output "${pathout}section_5/" 
		do ${pathdo}section_5.do 
		

shell rm -r "./temp" 
clear all




