/*--------------------------------------------------------
----------------------------------------------------------
Section 4 - Results
----------------------------------------------------------
--------------------------------------------------------*/
		
	/*--------------------------------------------------------
	Declare variables of interest
	* --------------------------------------------------------*/	
	global var_paper "p_lead_j p_theory e_se" 
	global var_structH "e_anglo e_dvping b3.e_period_enc"  
	global var_methodH "b3.e_beta_type_enc b2.e_approach_enc e_covariates p_cross e_resid_wage b2.e_estimator_enc" 
	
	
	/*--------------------------------------------------------
	Program: generate the table
	--------------------------------------------------------*/
	cap program drop gentable
	program gentable	
		# d 
		esttab using "${output}\${tabname}.tex",  
		mtitles b(%5.3f) se(%5.3f) compress replace
		drop (_cons)
		starlevels(* 0.1 ** 0.05 *** 0.01) 
		noomitted
		nodepvars
		substitute(\_ _) 
		se label tex alignment(D{.}{.}{-1}) 
		title(Table Meta-Regressions \label{$tabname}) 
		scalars("mstudies Studies" "mmodel Model" "mmethod Method" "mi2 I2") 
		f ; 
		# d cr 

		# d 
		esttab using "${output}\${tabname}.rtf",  
		mtitles b(%5.3f) se(%5.3f) compress replace
		starlevels(* 0.1 ** 0.05 *** 0.01)   
		drop (_cons)
		se label   
		noomitted  
		nodepvars
		substitute(\_ _) 
		scalars("mstudies Studies" "mmodel Model" "mmethod Method" "mi2 I2")  ; 
		# d cr 
	end	
	
	cap program drop gentable_random
	program gentable_random	
		# d 
		esttab using "${output}\${tabname}.tex",  
		mtitles b(%5.3f) se(%5.3f) compress replace
		drop (_cons *.p_pub_year)
		starlevels(* 0.1 ** 0.05 *** 0.01) 
		noomitted
		nodepvars
		substitute(\_ _) 
		se label tex alignment(D{.}{.}{-1}) 
		title(Table Meta-Regressions \label{$tabname}) 
		scalars("mstudies Studies" "mmodel Model" "mmethod Method" "mi2 I2" "mtau Between-study variance") 
		f ; 
		# d cr 

		# d 
		esttab using "${output}\${tabname}.rtf",  
		mtitles b(%5.3f) se(%5.3f) compress replace
		starlevels(* 0.1 ** 0.05 *** 0.01)   
		drop (_cons *.p_pub_year)
		se label   
		noomitted  
		nodepvars
		substitute(\_ _) 
		scalars("mstudies Studies" "mmodel Model" "mmethod Method" "mi2 I2" "mtau Between-study variance") ; 
		# d cr 
	end	
	
	cap program drop addloc
	program addloc	
		estadd local mmodel = e(model)
		estadd local mmethod = e(method)
		estadd local mi2 = e(I2_res)
		estadd local mtau = e(tau2)
		
		preserve
		keep if e(sample)
		keep p_id
		duplicates drop
		su p_id
		estadd local mstudies =r(N)
		restore
	end
	
	
**# MAIN RESULTS
	
	*--------------------------------------------------------
	* Table 1 - Baseline table (all estimates, fixed-effects model)
	*--------------------------------------------------------
	global var_paper_noSE "p_lead_j p_theory" 
	
	eststo clear 
	global tabname "table1"

		usedata_all
		eststo: meta regress $var_paper_noSE, fixed
		addloc
			
		usedata_all
		eststo: meta regress $var_paper_noSE $var_structH, fixed
		addloc
		
		usedata_all
		eststo: meta regress $var_paper_noSE $var_structH $var_methodH, fixed
		addloc
		
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH, fixed
		addloc
		gentable
		
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
	
	gentable


	*--------------------------------------------------------
	* Table 2 - Magnitude, Sign, Significance
	*--------------------------------------------------------
	eststo clear 
	global tabname "table2"
	
		* Magnitude
		usedata_all_abs
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
		
		* Sign (dummy)
		usedata_all_d
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
		
		* Negative (absolute value)
		usedata_all
		keep if e_beta<0
		gen coeff = abs(e_beta)
		meta set coeff e_se, studylabel(p_id) studysize(nr_e) eslabel(Effect size (negative)) 
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
		
		* Positive
		usedata_all
		drop if e_beta<0
		meta set e_beta e_se, studylabel(p_id) studysize(nr_e) eslabel(Effect size (positive)) 
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
		
		* Significant estimates
		usedata_all
		drop if e_tstat>2.32
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
		
	gentable
		

	*--------------------------------------------------------
	* Table 3 - Skills
	*--------------------------------------------------------
	eststo clear 
	global tabname "table3"
	
		* Magniture + Low skilled natives
		usedata_all_abs
		keep if e_wage_skill=="low"
		eststo: meta regress $var_paper $var_structH $var_methodH b2.e_immig_skill_enc i.p_pub_year, fixed
		addloc
		
		* Sign (dummy) + Low skilled natives
		usedata_all_d
		keep if e_wage_skill=="low"
		eststo: meta regress $var_paper $var_structH $var_methodH b2.e_immig_skill_enc i.p_pub_year, fixed
		addloc
		
		* Magniture + High skilled natives
		usedata_all_abs
		keep if e_wage_skill=="high"
		eststo: meta regress $var_paper $var_structH $var_methodH b2.e_immig_skill_enc i.p_pub_year, fixed
		addloc
		
		* Sign (dummy) + High skilled natives
		usedata_all_d
		keep if e_wage_skill=="high"
		eststo: meta regress $var_paper $var_structH $var_methodH b2.e_immig_skill_enc i.p_pub_year, fixed
		addloc
		
	gentable

	
	
	
**# ROBUSTNESS
	
	*--------------------------------------------------------
	* Table B4 - Robustness of the model and format of the effect size
	*--------------------------------------------------------
	eststo clear 
	global tabname "tableB4"

	global var_methodH_beta "b2.e_approach_enc e_covariates p_cross e_resid_wage b2.e_estimator_enc" 

		* converted semi-elasticities, fixed-effects model
		usedata_ela_semi
		meta set semi e_se, eslabel(Effect size (semi-elasticity)) 
		eststo: meta regress $var_paper $var_structH $var_methodH_beta i.p_pub_year, fixed
		addloc
		
		* converted elasticities, fixed-effects model
		usedata_ela_semi
		meta set ela e_se, eslabel(Effect size (elasticity)) 
		eststo: meta regress $var_paper $var_structH $var_methodH_beta i.p_pub_year, fixed
		addloc
				
		* all estimates, random-effect model 
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, random
		addloc
	
	gentable_random
	
	
	*--------------------------------------------------------
	* Table B5 - Approaches
	*--------------------------------------------------------
	eststo clear 
	global tabname "tableB5"
	
	global var_methodH_app "p_cross e_resid_wage b2.e_estimator_enc" 
			
		* Pure spatial approach (or total effect)
		usedata_all
		tab e_approach
		keep if e_approach=="pure spatial"
		eststo: meta regress $var_paper $var_structH $var_methodH_app i.p_pub_year, fixed		
		addloc
		
		* National skill-cell approach
		usedata_all
		keep if e_approach=="national skill-cell"
		eststo: meta regress $var_paper $var_structH $var_methodH_app i.p_pub_year, fixed		
		addloc
		
		* Mixture approach
		usedata_all
		keep if e_approach=="mixture"
		eststo: meta regress $var_paper $var_structH $var_methodH_app i.p_pub_year, fixed		
		addloc
			
		* Relative effects (National skill-cell approach + Mixture approach)
		usedata_all
		keep if e_approach=="national skill-cell" | e_approach=="mixture"
		eststo: meta regress $var_paper $var_structH $var_methodH_app i.p_pub_year, fixed		
		addloc
				
	gentable
	
	
	*--------------------------------------------------------
	* Table B6 - Functional form + sub-samples
	*--------------------------------------------------------
	eststo clear 
	global tabname "tableB6"
	
		* Controling for the formating of the wage and immigration variables
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH b1.e_wage_freq_enc b3.e_immig_level_enc i.e_immig_def_enc i.p_pub_year, fixed
		addloc

		* Sub-samples
			* Natives only (excl studies looking at the entire pop)
			usedata_all
			keep if e_wage_pop!="all"
			eststo: meta regress $var_paper $var_structH $var_methodH b1.e_wage_freq_enc b3.e_immig_level_enc i.e_immig_def_enc i.p_pub_year, fixed
			addloc	
			
			* Native males 
			usedata_all
			keep if e_wage_gender=="males"
			eststo: meta regress $var_paper $var_structH $var_methodH b1.e_wage_freq_enc b3.e_immig_level_enc i.e_immig_def_enc i.p_pub_year, fixed
			addloc		
			
			* Native females 
			usedata_all
			keep if e_wage_gender=="females"
			eststo: meta regress $var_paper $var_structH $var_methodH b1.e_wage_freq_enc b3.e_immig_level_enc i.e_immig_def_enc i.p_pub_year, fixed
			addloc	
	
	gentable
	
	
	*--------------------------------------------------------
	* Table B7 - Displacement and space
	*--------------------------------------------------------
	eststo clear 
	global tabname "tableB7"
	
		* Displacement
		usedata_all
		gen byte spatial = (e_approach=="pure spatial")
		collapse (max) p_mobility spatial, by(p_id)
		unique p_id
		tab p_mobility spatial
		
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH p_mobility i.p_pub_year, fixed		
		addloc
		
		* Displacement + Control for (un)employment 			
		usedata_all
		eststo: meta regress $var_paper $var_structH $var_methodH p_mobility e_key_cov_un_empl i.p_pub_year, fixed		
		addloc
		pwcorr p_mobility e_key_cov_un_empl, star(0.05) 
		
		* Anglo-Saxon countries only
		usedata_all
		keep if e_anglo==1
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed		
		addloc
		
		* The US only
		usedata_all
		keep if e_us==1
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed		
		addloc
		
		* Developing countries only
		usedata_all
		keep if e_dvping==1
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed		
		addloc
		
		* Baseline with the shares of agri and manuf sectors (World Development Indicators, World Bank)
		usedata_all
		eststo: meta regress $var_paper $var_structH e_perc_agri e_perc_manuf $var_methodH i.p_pub_year, fixed		
		addloc
		
	gentable

	
	*--------------------------------------------------------
	* Table B8 - Longhi et al 2005 + Before/After 2003
	*--------------------------------------------------------
	eststo clear 
	global tabname "tableB8"

		* Longhi et al. 2005
		usedata_all
		keep if p_longhi2005==1 
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc

		* Before 2003
		usedata_all
		keep if p_pub_year<=2003
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc

		* After 2003
		usedata_all
		keep if p_pub_year>2003
		eststo: meta regress $var_paper $var_structH $var_methodH i.p_pub_year, fixed
		addloc
	
	gentable

	
	
